package examples.entity.intro;

import java.util.Iterator;
import java.util.List;

import javax.naming.Context;
import javax.naming.InitialContext;

/**
 * Sample client code for an Account entity that is accessed through
 * a stateful session bean facade.
 */
public class AccountClient {
    
    public static void main(String[] args)  {       
        AccountInterface account = null;

        try {
            /*
             * Get a reference to the Account Session Object 
             */
            Context ctx = new InitialContext(System.getProperties());
            account = (AccountInterface)ctx.lookup(AccountInterface.class.getName());
            Bank bank = (Bank)ctx.lookup(Bank.class.getName());
            
            /*
             * Let's find existing accounts in the bank...
             */
            List<Account> accounts = bank.listAccounts();  
            
            /* 
             * ... and print them to the screen 
             */
            System.out.println("--- Accounts in this bank ---");
            for(Iterator iter = accounts.iterator(); iter.hasNext();) {
                System.out.println(iter.next());
            }
            System.out.println("-----------------------------");
            
            /*
             * Open the account  
             */
            account.open(4444);
            System.out.println("Initial Balance = " + account.getBalance());

            /*
             * Deposit $100 into the account
             */
            account.deposit(100);

            /*
             * Retrieve the resulting balance both from 
             * the original and the local copy
             */
            System.out.println("After depositing $100, the account balance is: $"
                    + account.getBalance());

            /*
             * Try to withdraw $150
             */
            System.out.println("Now trying to withdraw $150.");
            int withdrawn = account.withdraw(150);
            if(withdrawn != 150) 
                System.out.println("No success...");
            else
                System.out.println("Success, got the money!");
            
            System.out.println("Finally, the account balance is: $"
                    + account.getBalance());
            
        } catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        } 
    }
}
